isOdd <- function(x) x %% 2 == 1L

makeOdd <- function(x) x+!isOdd(x)

invertMask <- function(x) {
    return(bwlabel(x == 0L))
}

filterObjects <- function(x, minObjectSize, maxObjectSize) {
    dim0 <- dim(x)
    if (length(dim0) > 3) stop ("'x' should be a three-dimensional array")
    if (length(dim0) == 2) dim(x) <- c(dim0, 1)
    for (i in seq_len(dim(x)[3])) {
        tab <- tabulate(x[, , i])
        ind <- which(tab < minObjectSize | tab > maxObjectSize)
        if (length(ind) > 0) x[, , i][x[, , i] %in% ind] <- 0L
    }
    return(x)
}

segmentFurrowAllStacks <- function(x, L=17, filterSize=3, threshOffset=0.001,
    closingSize=3, minObjectSize=2^5, maxObjectSize=2^10) {
    if (length(dim(x)) != 4) warning("Image with 4 dimensions expected")
    if (length(filterSize) == 1L && !isOdd(filterSize))
        stop("Please use an odd integer for 'filterSize'")
    if (!isOdd(L)) stop("Please use an odd integer for 'L'")

    nStacks <- dim(x)[3]
    nTpts <- dim(x)[4]
    z <- makeBrush(size=filterSize, shape="gaussian", sigma=filterSize/2)
    for (i in seq_len(nStacks))
        for (j in seq_len(nTpts)) {
            x0 <- x[, , i, j]
            x[, , i, j] <- filter2(x0, z)
        }
    mk <- function(x) makeBrush(size=x, shape="disc")
    mask <- hs <- vector("list", nStacks)
    for (i in seq_len(nStacks)) {
        message("Thresholding stack", i)
        mask[[i]] <- thresh(x=x[, , i, ], w=L/2, h=L/2, offset=threshOffset)
        message("Closing stack", i)
        mask[[i]] <- closing(mask[[i]], mk(closingSize))
        message("Label objects stack", i)
        mask[[i]] <- bwlabel(mask[[i]])
        message("Remove objects stack", i)
        mask[[i]] <- filterObjects(mask[[i]], minObjectSize, Inf)
        message("Invert mask stack", i)
        mask[[i]] <- invertMask(mask[[i]])
        message("Fill holes stack", i)
        mask[[i]] <- fillHull(mask[[i]])
        message("Remove objects 2 stack", i)
        mask[[i]] <- filterObjects(mask[[i]], 0, maxObjectSize)
        message("Reenumerate cell ids stack", i)
        mask[[i]] <- reenumerate(mask[[i]])
        message("Propagate stack", i)
        mask[[i]] <- propagate(x[, , i, ], seeds=mask[[i]])
        message("Remove objects 3 stack", i)
        mask[[i]] <- filterObjects(mask[[i]], minObjectSize, maxObjectSize)
        message("Paint objects stack", i)
        hs[[i]] <- paintObjects(x=mask[[i]], tgt=normalize(x[, , i, ]),
            col="yellow")
    }
    return(list(x=x, mask=mask, hs=hs))
}
