## ----vignetteSetup, echo=FALSE, message=FALSE, warning = FALSE----------------
## Bib setup
library(RefManageR)
bib <- c(eoPredData = citation("eoPredData")[1])

## ----"citation"---------------------------------------------------------------
## Citation info
citation("eoPredData")

## ----eval = FALSE-------------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# BiocManager::install("ExperimentHub")
# BiocManager::install("mixOmics")

## ----"start", message=FALSE, eval=FALSE---------------------------------------
# library(ExperimentHub)
# eh <- ExperimentHub()
# query(eh, "eoPredData")
# 
# library(mixOmics)
# # model object
# eoPredModel <- eh[['EH8090']]
# # test object
# x_test <- eh[['EH8403']]
# dim(x_test) # 452,453 by 49
# x_test <- x_test[rownames(x_test) %in% colnames(eoPredModel$X),]
# dim(x_test) # 341,281 by 49
# # code to predict on x_test
# predictions <- predict(eoPredModel, t(x_test), dist = "max.dist")

## ----reproduce3, echo=FALSE---------------------------------------------------
## Session info
sessionInfo()

## ----vignetteBiblio, results="asis", echo=FALSE, warning=FALSE, message=FALSE----
RefManageR::PrintBibliography(
    bib, .opts = list(hyperlink = "to.doc", style = "html"))

