% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.r
\name{foroutan2017_se}
\alias{foroutan2017_se}
\title{TGFb stimulated cell lines from Foroutan et al. (2017)}
\format{
A SummarizedExperiment object, containing gene expression data of
human cell lines treated with TGFb. The \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::colData()}}
function can be used to access the sample annotations.
}
\description{
Foroutan et al. collected data from multiple different studies where various
cell lines (from various tissues of origin) were stimulated with transforming
growth factor beta (TGFb) to induce an epithelial to mesenchymal transition
(EMT). Since the data were from different studies (and platforms), the
surrogate variable analysis (SVA) and ComBat approaches were applied to
correct for batch effects.
}
\details{
Data from this publication were downloaded from figshare and processed into a
SummarizedExperiment object. Sample annotations were retrieved from the
original publication.
}
\examples{
library(ExperimentHub)
eh <- ExperimentHub()
emt_datasets <- query(eh, "emtdata")
}
\references{
Foroutan, M., Cursons, J., Hediyeh-Zadeh, S., Thompson, E. W., &
Davis, M. J. (2017). A transcriptional program for detecting TGFb-induced
EMT in Cancer. Molecular Cancer Research, 15(5), 619-631.
}
