% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_conversion.R
\name{asDGEList}
\alias{asDGEList}
\title{Convert a SummarizedExperiment object to a DGEList object}
\usage{
asDGEList(se, assay_name = "counts")
}
\arguments{
\item{se}{a SummarizedExperiment object.}

\item{assay_name}{a character, specifying the assay to retrieve.}
}
\value{
a DGEList object
}
\description{
This function converts a SummarizedExperiment object to a DGEList object to
enhance differential expression analysis using the edgeR package.
}
\examples{
library(ExperimentHub)

eh = ExperimentHub()
query(eh, 'emtdata')

cursons2018_se = eh[['EH5440']]
cursons2018_dge = asDGEList(cursons2018_se)

}
