% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viper_wrapper.R
\name{run_viper}
\alias{run_viper}
\title{VIPER wrapper}
\usage{
run_viper(input, regulons, options = list(), tidy = FALSE, assay_key = "RNA")
}
\arguments{
\item{input}{An object containing a gene expression matrix with genes
(HGNC/MGI symbols) in rows and samples in columns. The object can be a
simple matrix/data frame or more complex objects such as
\code{\link[Biobase:class.ExpressionSet]{ExpressionSet}},
\code{\link[Seurat:Seurat-class]{Seurat}} or
\code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}}
objects.}

\item{regulons}{\code{\link[=dorothea_hs]{DoRothEA}} regulons in table
format.}

\item{options}{A list of named options to pass to
\code{\link[viper]{viper}} such as \code{minsize} or
\code{method}. These options should not include, \code{eset} or
\code{regulon}.}

\item{tidy}{Logical, whether computed TF activities scores should be returned
in a tidy format.}

\item{assay_key}{Only applies if the input is a 
\code{\link[Seurat:Seurat-class]{Seurat}} object. It selects the
name of the assay from where to extract the normalized expression data.}
}
\value{
A matrix of normalized enrichment scores for each TF across all
 samples. Of note, if you provide Bioconductor objects as input the function
 will return this object with added TF activities at appropriate slots. e.g.
 Seurat object with a new assay called \code{dorothea}. For all
 other inputs the function will return a matrix. If \code{tidy} is
 \code{TRUE} the normalized enrichment scores are returned in a tidy format
 (not supported for Bioconductor objects).
}
\description{
This function is a convenient wrapper for the
\code{\link[decoupleR]{run_viper}} function using DoRothEA regulons.
}
\examples{
# use example gene expression matrix from bcellViper package
library(bcellViper)
data(bcellViper, package = "bcellViper")
# acessing (human) dorothea regulons
# for mouse regulons: data(dorothea_mm, package = "dorothea")
data(dorothea_hs, package = "dorothea")
# run viper
tf_activities <- run_viper(dset, dorothea_hs,
                          options =  list(method = "scale", minsize = 4,
                          eset.filter = FALSE, cores = 1,
                          verbose = FALSE))
}
