## ----style, echo = FALSE, results = 'asis'------------------------------------
BiocStyle::markdown()

## ----echo = FALSE-------------------------------------------------------------
suppressPackageStartupMessages(library("tidyverse"))

## ----install, eval=FALSE------------------------------------------------------
# install.packages("BiocManager")
# BiocManager::install("depmap")

## ----import_EH, message = FALSE-----------------------------------------------
library("depmap")
library("ExperimentHub")

## ----ehquery------------------------------------------------------------------
## create ExperimentHub query object
eh <- ExperimentHub()
query(eh, "depmap")

## ----eval = FALSE-------------------------------------------------------------
# eh[["EH2260"]]

## -----------------------------------------------------------------------------
depmap::depmap_rnai()

## ----eval = FALSE-------------------------------------------------------------
# eh[["EH2261"]]

## -----------------------------------------------------------------------------
depmap::depmap_crispr()

## ----eval = FALSE-------------------------------------------------------------
# eh[["EH2262"]]

## -----------------------------------------------------------------------------
depmap::depmap_copyNumber()

## ----eval = FALSE-------------------------------------------------------------
# eh[["EH2263"]]

## -----------------------------------------------------------------------------
depmap::depmap_RPPA()

## ----eval = FALSE-------------------------------------------------------------
# eh[["EH2264"]]

## -----------------------------------------------------------------------------
depmap::depmap_TPM()

## ----eval = FALSE-------------------------------------------------------------
# eh[["EH2266"]]

## -----------------------------------------------------------------------------
depmap::depmap_metadata()

## ----eval = FALSE-------------------------------------------------------------
# eh[["EH2265"]]

## -----------------------------------------------------------------------------
depmap::depmap_mutationCalls()

## ----eval = FALSE-------------------------------------------------------------
#  eh[["EH3087"]]

## -----------------------------------------------------------------------------
depmap::depmap_drug_sensitivity()

## ----eval = FALSE-------------------------------------------------------------
# eh[["EH3459"]]

## -----------------------------------------------------------------------------
depmap::depmap_proteomic()

## -----------------------------------------------------------------------------
dmsets()

## ----message=FALSE------------------------------------------------------------
library(tidyverse)
dmsets() |>
    filter(grepl("20Q", title))

## -----------------------------------------------------------------------------
dmfiles()

## -----------------------------------------------------------------------------
dmfiles() |>
    filter(dataset_id == 20564034)

## -----------------------------------------------------------------------------
dmfiles() |>
    filter(name == "prism-repurposing-20q2-primary-screen-cell-line-info.csv") |>
    dmget()

## -----------------------------------------------------------------------------
dmfiles() |>
    filter(name == "prism-repurposing-20q2-primary-screen-cell-line-info.csv") |>
    dmget() |>
    read_csv()

## -----------------------------------------------------------------------------
ids_2020 <- filter(dmsets(), grepl("20Q", title)) |>
    pull(dataset_id)

dmfiles() |>
    filter(dataset_id %in% ids_2020) |>
    filter(grepl("README", name)) |>
    dmget()

## ----echo = FALSE-------------------------------------------------------------
sessionInfo()

