% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_curatedTBData.R
\name{subset_curatedTBData}
\alias{subset_curatedTBData}
\title{Subset curatedTBData based on single/multiple conditions}
\usage{
subset_curatedTBData(
  theObject,
  annotationColName,
  annotationCondition,
  assayName = NULL
)
}
\arguments{
\item{theObject}{A
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment} or
\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment} object.}

\item{annotationColName}{A character indicates
feature of interest in the object's annotation data.}

\item{annotationCondition}{A vector of character indicates
conditions want to be selected.}

\item{assayName}{A character indicates
the name of the assay from the input object. The default is \code{NULL}.
When \code{assayName} is \code{NULL}, the function selects
the first assay along assay list.}
}
\value{
A \link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}
  object containing subjects with desired annotation conditions.
}
\description{
The function selects desired samples from curatedTBData
database based pre-specified conditions
}
\examples{
obj <-  curatedTBData("GSE74092", dry.run = FALSE, curated.only = TRUE)
subset_curatedTBData(obj[[1]], annotationColName = "TBStatus",
                     annotationCondition = c("Control","PTB"))

}
