% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiermannMelaMetasData.R
\name{BiermannMelaMetasData}
\alias{BiermannMelaMetasData}
\title{Melanoma metastasis slide-seq2 data}
\usage{
BiermannMelaMetasData(
  dataset = datasets,
  file_path = ".",
  force = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{dataset}{Which dataset to use, must be one of "MBM05_rep1" and
"ECM01_rep1".}

\item{file_path}{Path to save downloaded files for the \code{*Output}
functions which don't return an SFE object.}

\item{force}{Logical, whether to force redownload if the files are already
present. Defaults to \code{FALSE}.}

\item{verbose}{Whether to display progress of download.}
}
\value{
A \code{SpatialFeatureExperiment} object.
}
\description{
This function can download one of the human melanoma brain metastasis (MBM)
samples and one of the melanoma extracranial metastasis (ECM) samples from
the paper Dissecting the treatment-naive ecosystem of human melanoma brain
metastasis, \href{https://doi.org/10.1016/j.cell.2022.06.007}{Biermann et
al}. The datasets are \code{GSM6025935_MBM05_rep1} and
\code{GSM6025946_ECM01_rep1}. The raw counts and cell metadata were
downloaded from GEO. The raw counts, QC metrics such as number of UMIs and
genes detected per barcode, and centroid coordinates as \code{sf} POINT
geometry, are included in the SFE object.
}
\examples{
sfe <- BiermannMelaMetasData()
}
