% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation_datasets.R
\docType{data}
\name{methylation}
\alias{methylation}
\alias{BRCA.methylation}
\alias{BRCA.methylation,COAD.methylation,COADREAD.methylation,GBM.methylation,GBMLGG.methylation,KIPAN.methylation,KIRC.methylation,KIRP.methylation,LAML.methylation,LUAD.methylation,LUSC.methylation,OV.methylation,OV.methylation1,OV.methylation2,READ.methylation,STAD.methylation,STES.methylation,UCEC.methylation}
\alias{COAD.methylation}
\alias{COADREAD.methylation}
\alias{GBM.methylation}
\alias{GBMLGG.methylation}
\alias{KIPAN.methylation}
\alias{KIRC.methylation}
\alias{KIRP.methylation}
\alias{LAML.methylation}
\alias{LUAD.methylation}
\alias{LUSC.methylation}
\alias{OV.methylation2}
\alias{OV.methylation1}
\alias{READ.methylation}
\alias{STAD.methylation}
\alias{STES.methylation}
\alias{UCEC.methylation}
\title{Methylation datasets from TCGA project}
\source{
\url{http://gdac.broadinstitute.org/}
}
\usage{
BRCA.methylation

COAD.methylation

COADREAD.methylation

GBM.methylation

GBMLGG.methylation

KIPAN.methylation

KIRC.methylation

KIRP.methylation

LAML.methylation

LUAD.methylation

LUSC.methylation

OV.methylation2

OV.methylation1

READ.methylation

STAD.methylation

STES.methylation

UCEC.methylation
}
\value{
Data frames with methylation data.
}
\description{
Package provides methylation (humanmethylation27) datasets from The Cancer Genome Atlas Project for
all cohorts types from \url{http://gdac.broadinstitute.org/}.
Data were downloaded using \link{RTCGA-package} and contain snapshots for
the date: \code{2015-11-01}. The process is described here:
\url{http://rtcga.github.io/RTCGA/}.
Use cases, examples and information about datasets in \pkg{RTCGA.data}
family can be found here: \code{browseVignettes("RTCGA")}. Methylation data format
is explained here \url{https://wiki.nci.nih.gov/display/TCGA/DNA+methylation}.
Converting \pkg{RTCGA.methylation} datasets from \code{data.frames} to Bioconductor classes is explained here \link{convertTCGA}.
}
\details{
\code{browseVignettes("RTCGA")}
}
\examples{

\dontrun{
browseVignettes("RTCGA")
}


}
\keyword{datasets}
