\name{PWMEnrich.Dmelanogaster.background-package}
\alias{PWMEnrich.Dmelanogaster.background-package}
\alias{PWMEnrich.Dmelanogaster.background}
\alias{MotifDb.Dmel.PFM}
\alias{MotifDb.Dmel}
\alias{PWMLogn.dm3.MotifDb.Dmel}
\alias{PWMCutoff4.dm3.MotifDb.Dmel}
\alias{PWMCutoff5.dm3.MotifDb.Dmel}
\alias{PWMPvalueCutoff1e2.dm3.MotifDb.Dmel}
\alias{PWMPvalueCutoff1e3.dm3.MotifDb.Dmel}
\alias{PWMPvalueCutoff1e4.dm3.MotifDb.Dmel}
\alias{dm3.upstream2000}
\docType{package}

\title{
  PWMEnrich.Dmelanogaster.background package overview
}

\description{
    This package provides a set of pre-compiled genomic background files for the \code{PWMEnrich} package and D. melanogaster. The backgrounds
  were pre-compiled using unique promoters of Drosophila melanogaster. 
  
  \itemize{
  	\item \code{MotifDb.Dmel.PFM} - a list of 740 position frequency matrices (PFMs) from \code{MotifDb}
  	
  	\item \code{MotifDb.Dmel} - the corresponding PWMs generated by using the background frequencies of A,C,G,T in a set of 10031 2kb promoters in D. Melanogaster. 
  	
  	\item \code{PWMLogn.dm3.MotifDb.Dmel} - pre-compiled threshold-free lognormal background for JASPAR insects PWMs. 
  	The lognormal distribution is fitted to 1kb fragments of 10031 2kb Drosophila Melanogaster (dm3) promoters. 
  	For each gene one promoter is taken (from the first transcript). 
  	
  	\item \code{PWMCutoff4.dm3.MotifDb.Dmel}, \code{PWMCutoff5.dm3.MotifDb.Dmel} - pre-compiled Z-score background with cutoff of 4 and 5 (base e) for 
  	JASPAR insects PWMs. The number of hits above the score cutoff is counted in 10031 2kb Drosophila Melanogaster
  	(dm3) promoters. For each gene one promoter is taken (from the first transcript). 
  	
  	\item \code{PWMPvalueCutoff1e2.dm3.MotifDb.Dmel}, \code{PPWMPvalueCutoff1e3.dm3.MotifDb.Dmel},
  	\code{PPWMPvalueCutoff1e4.dm3.MotifDb.Dmel} - pre-compiled Z-score background with P-value cutoff of 0.01, 0.001, and 0.0001 for 
  	JASPAR insects PWMs. The number of hits with smaller P-value than cutoff is counted in 10031 2kb Drosophila Melanogaster
  	(dm3) promoters. For each gene one promoter is taken (from the first transcript).
  	
  }
}

\usage{
	data(MotifDb.Dmel.PFM)
	data(MotifDb.Dmel)
	data(PWMLogn.dm3.MotifDb.Dmel)
	data(PWMCutoff4.dm3.MotifDb.Dmel)
	data(PWMCutoff5.dm3.MotifDb.Dmel)
	data(PWMPvalueCutoff1e2.dm3.MotifDb.Dmel)
	data(PWMPvalueCutoff1e3.dm3.MotifDb.Dmel)
	data(PWMPvalueCutoff1e4.dm3.MotifDb.Dmel)
}

\details{
	All of these objects were created with the appropriate functions available in the \code{PWMEnrich} package (see Section 'See also'). We
	recommend using these functions to generate backgrounds for a custom set of background sequences and/or DNA motifs. 
	
	This package also contains the 2kb upstream sequences for Drosophila genes (\code{dm3.upstream2000}) which were removed from the BSgenome.Dmelanogaster.UCSC.dm3 package
	starting from Bioconductor version 3.0. 
}

\examples{
	data(PWMLogn.dm3.MotifDb.Dmel)
	
	res = motifEnrichment(DNAString("TGCATCAAGTGTGTAGTGCGATGAATGC"), PWMLogn.dm3.MotifDb.Dmel)
	
	head(motifRankingForGroup(res))
}

\author{
  Robert Stojnic\cr
  Cambridge Systems Biology Centre\cr
  University of Cambridge, UK

  Maintainer: Robert Stojnic \email{robert.stojnic@gmail.com}
}

\seealso{
	 \code{\link{makeBackground}}, \code{\link{makePWMLognBackground}}, \code{\link{makePWMCutoffBackground}}, \code{\link{makePWMEmpiricalBackground}}.
}

\keyword{ package }
