/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.node_based.experimental;

import java.util.Set;
import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.node_based.Sim_DAG_node_abstract;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class Sim_pairwise_DAG_node_GL_GraSM
extends Sim_DAG_node_abstract {
    public static final String beta_param_name = "beta";
    private double beta = 0.0;

    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        double ic_a = c.getIC(conf.getICconf(), a);
        double ic_b = c.getIC(conf.getICconf(), b);
        Set<URI> disjointAncs = c.getLCAs(a, b);
        double sumIC = 0.0;
        for (URI v : disjointAncs) {
            sumIC += c.getIC(conf.getICconf(), v);
        }
        double sim_grasm = sumIC / (double)disjointAncs.size();
        if (conf.containsParam(beta_param_name)) {
            this.beta = conf.getParamAsDouble(beta_param_name);
        }
        return this.sim(ic_a, ic_b, sim_grasm, this.beta);
    }

    public double sim(double ic_a, double ic_b, double ic_mica, double beta) throws SLIB_Ex_Critic {
        double den = ic_a + ic_b + (beta - 2.0) * ic_mica;
        double j = 0.0;
        if (den != 0.0) {
            j = beta * ic_mica / den;
        }
        return j;
    }
}

