/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.accessor;

import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.Direction;
import slib.utils.impl.SetUtils;

public class GraphAccessor {
    static Logger logger = LoggerFactory.getLogger(GraphAccessor.class);

    public static Set<URI> getClasses(G graph) {
        logger.debug("retrieving Classes");
        HashSet<URI> classes = new HashSet<URI>();
        for (E e : graph.getE(RDFS.SUBCLASSOF)) {
            classes.add(e.getSource());
            classes.add(e.getTarget());
        }
        for (E e : graph.getE(RDF.TYPE)) {
            classes.add(e.getTarget());
            if (!e.getTarget().equals(OWL.CLASS) && !e.getTarget().equals(RDFS.CLASS)) continue;
            classes.add(e.getSource());
        }
        logger.debug("Classes detected " + classes.size() + "/" + graph.getV().size());
        return classes;
    }

    public static Set<URI> getInstances(G graph) {
        HashSet<URI> instances = new HashSet<URI>(graph.getV());
        for (E e : graph.getE(RDFS.SUBCLASSOF)) {
            instances.remove(e.getTarget());
            instances.remove(e.getSource());
        }
        for (E e : graph.getE(RDF.TYPE)) {
            URI o = e.getTarget();
            if (!o.equals(RDFS.CLASS) && !o.equals(OWL.CLASS) && !o.equals(RDFS.LITERAL) && !o.equals(RDFS.DATATYPE) && !o.equals(RDF.PROPERTY) && !o.equals(RDF.XMLLITERAL)) continue;
            instances.remove(e.getSource());
        }
        return instances;
    }

    public static Set<URI> getV_NoEdgeType(G g, URI edgeType, Direction dir) {
        return GraphAccessor.getV_NoEdgeType(g, SetUtils.buildSet(edgeType), dir);
    }

    public static Set<URI> getV_NoEdgeType(G g, Set<URI> edgeTypes, Direction dir) {
        boolean isValid;
        HashSet<URI> valid = new HashSet<URI>();
        Set<URI> vSel = g.getV();
        if (dir == Direction.OUT || dir == Direction.BOTH) {
            for (URI v : vSel) {
                Set<E> edgesSel = g.getE(v, Direction.OUT);
                isValid = true;
                for (E e : edgesSel) {
                    if (edgeTypes != null && !edgeTypes.contains(e.getURI())) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) continue;
                valid.add(v);
            }
        }
        if (dir == Direction.IN || dir == Direction.BOTH) {
            for (URI v : vSel) {
                Set<E> edges = g.getE(v, Direction.IN);
                isValid = true;
                for (E e : edges) {
                    if (edgeTypes != null && !edgeTypes.contains(e.getURI())) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) continue;
                valid.add(v);
            }
        }
        return valid;
    }
}

