/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.manager.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.config.RepositoryConfig;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.manager.RepositoryInfo;
import org.openrdf.repository.manager.RepositoryManager;

public class TypeFilteringRepositoryManager
extends RepositoryManager {
    private final String type;
    private final RepositoryManager delegate;

    public TypeFilteringRepositoryManager(String type, RepositoryManager delegate) {
        assert (type != null) : "type must not be null";
        assert (delegate != null) : "delegate must not be null";
        this.type = type;
        this.delegate = delegate;
    }

    @Override
    public void initialize() throws RepositoryException {
        this.delegate.initialize();
    }

    @Override
    public URL getLocation() throws MalformedURLException {
        return this.delegate.getLocation();
    }

    @Override
    protected Repository createSystemRepository() throws RepositoryException {
        throw new UnsupportedOperationException("The system repository cannot be created through this wrapper. This method should not have been called, the delegate should take care of it.");
    }

    @Override
    public Repository getSystemRepository() {
        return this.delegate.getSystemRepository();
    }

    @Override
    public String getNewRepositoryID(String baseName) throws RepositoryException, RepositoryConfigException {
        return this.delegate.getNewRepositoryID(baseName);
    }

    @Override
    public Set<String> getRepositoryIDs() throws RepositoryException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String id : this.delegate.getRepositoryIDs()) {
            try {
                if (!this.isCorrectType(id)) continue;
                result.add(id);
            }
            catch (RepositoryConfigException e) {
                throw new RepositoryException(e);
            }
        }
        return result;
    }

    @Override
    public boolean hasRepositoryConfig(String repositoryID) throws RepositoryException, RepositoryConfigException {
        boolean result = false;
        if (this.isCorrectType(repositoryID)) {
            result = this.delegate.hasRepositoryConfig(repositoryID);
        }
        return result;
    }

    @Override
    public RepositoryConfig getRepositoryConfig(String repositoryID) throws RepositoryConfigException, RepositoryException {
        RepositoryConfig result = this.delegate.getRepositoryConfig(repositoryID);
        if (result != null && !this.isCorrectType(result)) {
            this.logger.debug("Surpressing retrieval of repository {}: repository type {} did not match expected type {}", result.getID(), result.getRepositoryImplConfig().getType(), this.type);
            result = null;
        }
        return result;
    }

    @Override
    public void addRepositoryConfig(RepositoryConfig config) throws RepositoryException, RepositoryConfigException {
        if (!this.isCorrectType(config)) {
            throw new UnsupportedOperationException("Only repositories of type " + this.type + " can be added to this manager.");
        }
        this.delegate.addRepositoryConfig(config);
    }

    @Override
    @Deprecated
    public boolean removeRepositoryConfig(String repositoryID) throws RepositoryException, RepositoryConfigException {
        boolean result = false;
        if (this.isCorrectType(repositoryID)) {
            result = this.delegate.removeRepositoryConfig(repositoryID);
        }
        return result;
    }

    @Override
    public Repository getRepository(String id) throws RepositoryConfigException, RepositoryException {
        Repository result = null;
        if (this.isCorrectType(id)) {
            result = this.delegate.getRepository(id);
        }
        return result;
    }

    @Override
    public Set<String> getInitializedRepositoryIDs() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String id : this.delegate.getInitializedRepositoryIDs()) {
            try {
                if (!this.isCorrectType(id)) continue;
                result.add(id);
            }
            catch (RepositoryConfigException e) {
                this.logger.error("Failed to verify repository type", e);
            }
            catch (RepositoryException e) {
                this.logger.error("Failed to verify repository type", e);
            }
        }
        return result;
    }

    @Override
    public Collection<Repository> getInitializedRepositories() {
        ArrayList<Repository> result = new ArrayList<Repository>();
        for (String id : this.getInitializedRepositoryIDs()) {
            try {
                Repository repository = this.getRepository(id);
                if (repository == null) continue;
                result.add(repository);
            }
            catch (RepositoryConfigException e) {
                this.logger.error("Failed to verify repository type", e);
            }
            catch (RepositoryException e) {
                this.logger.error("Failed to verify repository type", e);
            }
        }
        return result;
    }

    @Override
    protected Repository createRepository(String id) throws RepositoryConfigException, RepositoryException {
        throw new UnsupportedOperationException("Repositories cannot be created through this wrapper. This method should not have been called, the delegate should take care of it.");
    }

    @Override
    public Collection<RepositoryInfo> getAllRepositoryInfos(boolean skipSystemRepo) throws RepositoryException {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        for (RepositoryInfo repInfo : this.delegate.getAllRepositoryInfos(skipSystemRepo)) {
            try {
                if (!this.isCorrectType(repInfo.getId())) continue;
                result.add(repInfo);
            }
            catch (RepositoryConfigException e) {
                throw new RepositoryException(e.getMessage(), e);
            }
        }
        return result;
    }

    @Override
    public RepositoryInfo getRepositoryInfo(String id) throws RepositoryException {
        try {
            if (this.isCorrectType(id)) {
                return this.delegate.getRepositoryInfo(id);
            }
            return null;
        }
        catch (RepositoryConfigException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    @Override
    public void refresh() {
        this.delegate.refresh();
    }

    @Override
    public void shutDown() {
        this.delegate.shutDown();
    }

    @Override
    protected void cleanUpRepository(String repositoryID) throws IOException {
        throw new UnsupportedOperationException("Repositories cannot be removed through this wrapper. This method should not have been called, the delegate should take care of it.");
    }

    protected boolean isCorrectType(String repositoryID) throws RepositoryConfigException, RepositoryException {
        boolean result;
        boolean bl = result = !"SYSTEM".equals(repositoryID);
        if (result) {
            result = this.isCorrectType(this.delegate.getRepositoryConfig(repositoryID));
        }
        return result;
    }

    protected boolean isCorrectType(RepositoryConfig repositoryConfig) {
        boolean result = false;
        if (repositoryConfig != null) {
            result = repositoryConfig.getRepositoryImplConfig().getType().equals(this.type);
        }
        return result;
    }
}

