% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AtlasSampleMetadata.R
\docType{data}
\name{AtlasSampleMetadata}
\alias{AtlasSampleMetadata}
\title{Sample metadata from the Pijuan-Sala et al. embryo atlas}
\format{
A data frame containing information for each 10x sample
of the embryo atlas.
This object contains:
\describe{
\item{\code{sample}:}{Integer, 10x sample index.}
\item{\code{stage}:}{Character, developmental stage from which sample was generated.}
\item{\code{pool_index}:}{Integer, index for pools of embryos; samples with the same values are from the same pool of dissociated cells.}
\item{\code{seq_batch}:}{Integer, seqencing batch index; samples with the same values were multiplexed for sequencing.}
\item{\code{ncells}:}{Integer, number of cells (post-QC) per sample.}
}
Note that sample 11 is missing by design due to experimental failure: it is not available for download.
}
\usage{
AtlasSampleMetadata
}
\description{
A data frame containing stage and embryo pool information for
the atlas dataset.
}
\examples{
head(AtlasSampleMetadata)

}
\references{
Pijuan-Sala B, Griffiths JA, Guibentif C et al. (2019).
A single-cell molecular map of mouse gastrulation and early organogenesis.
\emph{Nature} 566, 7745:490-495.
}
\keyword{datasets}
