% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCATonsilData.R
\name{HCATonsilData}
\alias{HCATonsilData}
\title{Access the Tonsil Atlas data (RNA, ATAC, Multiome, CITE, Spatial)}
\usage{
HCATonsilData(
  assayType = c("RNA", "ATAC", "CITE", "Spatial"),
  cellType = "All",
  version = "2.0",
  processedCounts = TRUE
)
}
\arguments{
\item{assayType}{One of 'RNA', 'ATAC', 'Multiome', 'CITE' or 'Spatial'.}

\item{cellType}{A character vector of length 1 with the desired cell type.
A list of available cell types can be obtained using
\code{listCellTypes(assay_type)}.}

\item{version}{Version of the tonsil atlas data to retrieve: "1.0" (preprint)
or "2.0" (publication, default)}

\item{processedCounts}{Logical scalar. If \code{TRUE}, include the processed
(normalized) counts in addition to the raw counts in the
SingleCellExperiment object.}
}
\value{
A \linkS4class{SingleCellExperiment} object for the cellType
requested. For scATAC-seq, Multiome and CITE we provide the instructions
for downloading the Seurat objects in Zenodo (see vignette)
}
\description{
The data was downloaded from Zenodo
https://zenodo.org/record/8373756
}
\examples{
# retrieve the epithelial scRNA-seq dataset
sce_epithelial <- HCATonsilData(
  assayType = "RNA",
  cellType = "epithelial"
)
sce_epithelial
}
\author{
Ramon Massoni-Badosa
}
