% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChIPDBData.R
\name{getChIPDB}
\alias{getChIPDB}
\title{Retrieve ChIPDB dataset from ExperimentHub}
\usage{
getChIPDB(
  name = c("ENCODE_rE2G", "ENCODE_rE2G_25score", "ENCODE_rE2G_50score",
    "ENCODE_rE2G_75score", "ENCODE_rE2G_50depth", "ENCODE_rE2G_100depth",
    "ENCODE_rE2G_200depth", "ENCODE_rE2G_300depth", "CREdb", "GeneHancer")
)
}
\arguments{
\item{name}{A character string naming the dataset to retrieve.
Options:   "ENCODE_rE2G", "ENCODE_rE2G_25score", "ENCODE_rE2G_50score",
"ENCODE_rE2G_75score", "ENCODE_rE2G_50depth", "ENCODE_rE2G_100depth",
"ENCODE_rE2G_200depth", "ENCODE_rE2G_300depth",
"CREdb", "GeneHancer".}
}
\value{
A list object of class ChIPDB containing transcription factor–target gene mappings.
}
\description{
This function fetches ChIPDB objects (lists of transcription factor–target
gene associations) for use with the TFEA.ChIP package. Available datasets
include ENCODE, CREDB, and GeneHancer-derived collections.
}
\examples{
ChIPDB <- getChIPDB("ENCODE_rE2G_300depth")
}
