% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corum.R
\name{corum2list}
\alias{corum2list}
\title{Represent CORUM protein complex data as a simple list}
\usage{
corum2list(corum.df, subunit.id.type = c("UNIPROT", "ENTREZID"))
}
\arguments{
\item{corum.df}{A \code{data.frame} storing the CORUM protein complex data.
Typically obtained via \code{\link{getCorum}}.}

\item{subunit.id.type}{character. Supported options include \code{"UNIPROT"}
(default) and \code{"ENTREZID"}.}
}
\value{
A \code{list} with an entry for each complex. Each entry is a
character vector of subunit IDs.
}
\description{
Functionality for storing CORUM protein complex data in a
\code{list}.
}
\examples{
 # (1) Obtain the core set of CORUM complexes ...
 core <- getCorum(set = "core")
 
 # (2) ... turn into a list
 core.list <- corum2list(core)
}
\references{
CORUM: \url{http://mips.helmholtz-muenchen.de/corum/#download}
}
