% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioplex.R
\name{bioplex2graph}
\alias{bioplex2graph}
\title{Representation of BioPlex PPIs in a graph data structure}
\usage{
bioplex2graph(bioplex.df)
}
\arguments{
\item{bioplex.df}{a \code{data.frame} storing the Bioplex PPIs in a flat
from-to format. Typically obtained via \code{\link{getBioPlex}}.}
}
\value{
An object of class \code{graphNEL}.
}
\description{
Representation of BioPlex PPIs in a \code{graphNEL} object
from the \code{graph} package.
}
\examples{
# (1) Obtain the latest version of the 293T PPI network
bp.293t <- getBioPlex(cell.line = "293T", version = "3.0")

# (2) Turn the data into a graph 
bp.gr <- bioplex2graph(bp.293t)

}
\references{
BioPlex: \url{https://bioplex.hms.harvard.edu/interactions.php}
}
\seealso{
\code{\link{getBioPlex}}, \code{\link{ftM2graphNEL}}
}
