## ----install, eval=FALSE------------------------------------------------------
# if (!requireNamespace('BiocManager', quietly = TRUE))
#     install.packages('BiocManager')
# 
# BiocManager::install('ExperimentHub')
# BiocManager::install('AWAggregatorData')

## ----query datasets-----------------------------------------------------------
library(ExperimentHub)
eh = ExperimentHub()
query(eh, 'AWAggregatorData') # Require Bioconductor version 3.21 or later

## ----download datasets--------------------------------------------------------
# Benchmark Set 1
df = eh[['EH9637']]
# Benchmark Set 2
df = eh[['EH9638']]
# Benchmark Set 3
df = eh[['EH9639']]
# Pre-trained model incorporating the average coefficient of variation (CV) as 
# a feature
regr = eh[['EH9640']]
# Pre-trained model excluding CV as a feature
regr = eh[['EH9641']]

## ----session info-------------------------------------------------------------
sessionInfo()

