% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documented_data.R
\docType{data}
\name{rawNMRdata}
\alias{rawNMRdata}
\title{Raw 1D Bruker/text spectra from Salek \emph{et al.} (2007)}
\format{Raw 1D spectra (Brucker or txt formats)}
\source{
\url{https://www.ebi.ac.uk/metabolights/MTBLS1}
}
\description{
This dataset is a subset of the public datasets from Salek \emph{et al.} (2007).
The experiment has been designed to improve the understanding of early
stage of type 2 diabetes mellitus (T2DM) development. $^1$H-NMR human
metabolome was obtained from 25 healthy volunteers and 25 T2DM patients.
Raw 1D Bruker spectra were obtained from the MetaboLights database
(\url{https://www.ebi.ac.uk/metabolights/}, study MTBLS1).\cr
The dataset contains 50 spectra (columns in TXT file) and 31087 chemical 
shifts (rows in TXT file). Row names in the TXT file indicate the chemical 
shifts in ppm.
}
\examples{
# Raw 1D Bruker spectra
data_path <- system.file("extdata", "Human_diabetes_example",
                         package = "ASICSdata")
dir(data_path)
                         
# txt file
data_path <- system.file("extdata", "spectra_diabetes_example.txt",
                         package = "ASICSdata")
spectra <- read.table(data_path, header = TRUE, row.names = 1)
dim(spectra)
}
\references{
Salek R.M., Maguire M.L., Bentley E., Rubtsov D.V., Hough T., 
Cheeseman M., Nunez D., Sweatman B.C., Haselden J.N., Cox R.D., Connor S.C., 
Griffin J.L. (2007). A metabolomic comparison of urinary changes in type 2 
diabetes in mouse, rat, and human. \emph{Physiological genomics}, 
\strong{29}(2), 99-108. DOI: 10.1152/physiolgenomics.00194.2006
}
\seealso{
\code{\link{designData}}
}
