% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppiTables.R
\name{getIGraphFromPPI}
\alias{getIGraphFromPPI}
\title{Get Igraph representation of PPI}
\usage{
getIGraphFromPPI(ppi)
}
\arguments{
\item{ppi}{PPI \code{data.frame} with columns A and B, obtaioed
from functions like \code{\link{getPPIbyName}}}
}
\value{
\code{\link{igraph}} object with specified PPI network.
}
\description{
Combine information from PPI \code{data.frame} obtained with functions like
\code{\link{getPPIbyName}} or \code{\link{getPPIbyEntrez}} with information
about genes obtained from
\code{\link{getGenesByID}} to make  interpretable undirected PPI graph in
\code{\link{igraph}} format. In this format network could be further
analysed and visualized by algorithms in \code{\link{igraph}} package.
}
\examples{
library(igraph)
g <- getIGraphFromPPI(
    getPPIbyIDs(c(48, 129, 975, 4422, 5715, 5835), type = "lim")
)
plot(g, vertex.label = V(g)$RatName, vertex.size = 35)
}
\seealso{
\code{\link[=getPPIbyName]{getPPIbyName()}},
\code{\link[=getPPIbyEntrez]{getPPIbyEntrez()}}
and \code{\link[=getPPIbyIDs]{getPPIbyIDs()}} to get
PPI \code{data.frame},
\code{\link[=getTableFromPPI]{getTableFromPPI()}}
to get interpretable table representation of
the PPI \code{data.frame}.

Other {PPI functions}: 
\code{\link{getPPIbyEntrez}()},
\code{\link{getPPIbyIDs}()},
\code{\link{getPPIbyIDs4BrainRegion}()},
\code{\link{getPPIbyIDs4Compartment}()},
\code{\link{getPPIbyName}()},
\code{\link{getTableFromPPI}()}
}
\concept{{Igraph functions}}
\concept{{PPI functions}}
