% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compartments.R
\name{getGenes4Compartment}
\alias{getGenes4Compartment}
\title{Select genes from the list that found in compartment}
\usage{
getGenes4Compartment(ids, compartmentID)
}
\arguments{
\item{ids}{Gene IDs}

\item{compartmentID}{compartment ID}
}
\value{
data.frame described in \code{\link[=getGenesByID]{getGenesByID()}}
}
\description{
Select all genes from your list annotated for specific
compartment. Should be used with
\code{\link[=findGenesByEntrez]{findGenesByEntrez()}}
or \code{\link[=findGenesByName]{findGenesByName()}}
functions to obtain list of internal
IDs for your list of genes. Function lookups the Gene table
for specified localisation and returns main gene information
like internal Gene IDs, MGI ID, Human Entrez ID, Human Gene Name,
Mouse Entrez ID, Mouse Gene Name, Rat Entrez ID, Rat Gene Name.
}
\examples{
Genes <- getGenes4Compartment(c(1, 15, 156, 1500, 3000, 7000),
    compartmentID = 1
)
}
\seealso{
Other {Gene functions}: 
\code{\link{findGeneByCompartmentPaperCnt}()},
\code{\link{findGeneByPaperCnt}()},
\code{\link{findGeneByPapers}()},
\code{\link{findGenesByEntrez}()},
\code{\link{findGenesByName}()},
\code{\link{getAllGenes4Compartment}()},
\code{\link{getGenesByID}()}

Other {Compartment functions}: 
\code{\link{getAllGenes4Compartment}()},
\code{\link{getCompartments}()},
\code{\link{getPPIbyIDs4Compartment}()}
}
\concept{{Compartment functions}}
\concept{{Gene functions}}
