globals <- new.env(hash=TRUE, parent=emptyenv())

globals$DEBUG <- FALSE

## setup the path at package level so that DB can be accessed
## during package install/lazyload db creation.
##
## We reset the DB_PATH in .onLoad since we need to
## get the right one based on libpath
globals$DB_PATH <- system.file("extdata", "pd.2006.10.31.rn34.refseq.promoter.sqlite",
                               package="pd.2006.10.31.rn34.refseq.promoter")
if (nchar(globals$DB_PATH) == 0)
  stop("Unable to locate DB file")

initDbConnection <- function() {
    globals$dbCon <- dbConnect(dbDriver("SQLite"), dbname=globals$DB_PATH)
    globals$dbCon
}

getDb  <- function() {
    if (!is.null(globals$dbCon) && isIdCurrent(globals$dbCon))
      return(globals$dbCon)
    initDbConnection()
}

closeDb <- function() {
    ## FIXME: check for valid connection?
    sapply(dbListResults(globals$dbCon), dbClearResult)
    dbDisconnect(globals$dbCon)
    remove(list="dbCon", envir=globals)
}

.onLoad <- function(libname, pkgname) {
    require("methods", quietly=TRUE)
    require("RSQLite", quietly=TRUE)
    globals$DB_PATH <- system.file("extdata", "pd.2006.10.31.rn34.refseq.promoter.sqlite",
                                   package="pd.2006.10.31.rn34.refseq.promoter",
                                   lib.loc=libname)
    if (nchar(globals$DB_PATH) == 0)
      stop("Unable to locate DB file")
    ## Establish a connection to the SQLite DB
    initDbConnection()
}

.onUnload <- function(libpath) {
    closeDb()
}

pd.2006.10.31.rn34.refseq.promoter <- new("NgsTilingPDInfo",
                    genomebuild="RN 3.4 (rn4)",
                    getdb=getDb,
                    geometry=as.integer(strsplit("1024;768", ";")[[1]]),
                    annotation="pd.2006.10.31.rn34.refseq.promoter")

