datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Pt.eg <- function() showQCData("org.Pt.eg", datacache)
org.Pt.eg_dbconn <- function() dbconn(datacache)
org.Pt.eg_dbfile <- function() dbfile(datacache)
org.Pt.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Pt.eg_dbInfo <- function() dbInfo(datacache)

org.Pt.egORGANISM <- "Pan troglodytes"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Pt.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("CHIMP_DB", "org.Pt.eg", "Chimp", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Pt.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Pt.eg_dbconn())
}

