
\name{mogene21sttranscriptcluster_dbconn}

\alias{mogene21sttranscriptcluster_dbconn}
\alias{mogene21sttranscriptcluster_dbfile}
\alias{mogene21sttranscriptcluster_dbschema}
\alias{mogene21sttranscriptcluster_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  mogene21sttranscriptcluster_dbconn()
  mogene21sttranscriptcluster_dbfile()
  mogene21sttranscriptcluster_dbschema(file="", show.indices=FALSE)
  mogene21sttranscriptcluster_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{mogene21sttranscriptcluster_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{mogene21sttranscriptcluster_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{mogene21sttranscriptcluster_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{mogene21sttranscriptcluster_dbschema} prints the schema definition of the
  package annotation DB.

  \code{mogene21sttranscriptcluster_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{mogene21sttranscriptcluster_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{mogene21sttranscriptcluster_dbfile}: a character string with the path to the
  package annotation DB.

  \code{mogene21sttranscriptcluster_dbschema}: none (invisible \code{NULL}).

  \code{mogene21sttranscriptcluster_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(mogene21sttranscriptcluster_dbconn(), "SELECT COUNT(*) FROM probes")

  mogene21sttranscriptcluster_dbschema()

  mogene21sttranscriptcluster_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

