datacache <- new.env(hash=TRUE, parent=emptyenv())

mogene20stprobeset <- function() showQCData("mogene20stprobeset", datacache)
mogene20stprobeset_dbconn <- function() dbconn(datacache)
mogene20stprobeset_dbfile <- function() dbfile(datacache)
mogene20stprobeset_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mogene20stprobeset_dbInfo <- function() dbInfo(datacache)

mogene20stprobesetORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mogene20stprobeset.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mogene20stprobeset", "chip mogene20stprobeset", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("mogene20stprobeset.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mogene20stprobeset_dbconn())
}

