datacache <- new.env(hash=TRUE, parent=emptyenv())

moex10sttranscriptcluster <- function() showQCData("moex10sttranscriptcluster", datacache)
moex10sttranscriptcluster_dbconn <- function() dbconn(datacache)
moex10sttranscriptcluster_dbfile <- function() dbfile(datacache)
moex10sttranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
moex10sttranscriptcluster_dbInfo <- function() dbInfo(datacache)

moex10sttranscriptclusterORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "moex10sttranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "moex10sttranscriptcluster", "chip moex10sttranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("moex10sttranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(moex10sttranscriptcluster_dbconn())
}

