
\name{mgu74c_dbconn}

\alias{mgu74c_dbconn}
\alias{mgu74c_dbfile}
\alias{mgu74c_dbschema}
\alias{mgu74c_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  mgu74c_dbconn()
  mgu74c_dbfile()
  mgu74c_dbschema(file="", show.indices=FALSE)
  mgu74c_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{mgu74c_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{mgu74c_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{mgu74c_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{mgu74c_dbschema} prints the schema definition of the
  package annotation DB.

  \code{mgu74c_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{mgu74c_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{mgu74c_dbfile}: a character string with the path to the
  package annotation DB.

  \code{mgu74c_dbschema}: none (invisible \code{NULL}).

  \code{mgu74c_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(mgu74c_dbconn(), "SELECT COUNT(*) FROM probes")

  mgu74c_dbschema()

  mgu74c_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

