datacache <- new.env(hash=TRUE, parent=emptyenv())

mgu74av2 <- function() showQCData("mgu74av2", datacache)
mgu74av2_dbconn <- function() dbconn(datacache)
mgu74av2_dbfile <- function() dbfile(datacache)
mgu74av2_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mgu74av2_dbInfo <- function() dbInfo(datacache)

mgu74av2ORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mgu74av2.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mgu74av2", "chip mgu74av2", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("mgu74av2.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mgu74av2_dbconn())
}

