datacache <- new.env(hash=TRUE, parent=emptyenv())

lumiRatAll <- function() showQCData("lumiRatAll", datacache)
lumiRatAll_dbconn <- function() dbconn(datacache)
lumiRatAll_dbfile <- function() dbfile(datacache)
lumiRatAll_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
lumiRatAll_dbInfo <- function() dbInfo(datacache)

lumiRatAllORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "lumiRatAll.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "lumiRatAll", "chip lumiRatAll", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("lumiRatAll.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(lumiRatAll_dbconn())
}

