\name{lumiMouseIDMapping_dbconn}

\alias{lumiMouseIDMapping_dbconn}
\alias{lumiMouseIDMapping_dbfile}
\alias{lumiMouseIDMapping_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  lumiMouseIDMapping_dbconn()
  lumiMouseIDMapping_dbfile()
  lumiMouseIDMapping_dbInfo()
}

\arguments{
 
}

\details{
  \code{lumiMouseIDMapping_dbconn} returns a connection object to the package
  annotation DB.
  IMPORTANT: Don't call \code{\link[DBI]{dbDisconnect}} on the connection
  object returned by \code{lumiMouseIDMapping_dbconn} or you will
  break all the \code{\link[AnnotationDbi]{AnnDbObj}} objects defined in this package!

  \code{lumiMouseIDMapping_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{lumiMouseIDMapping_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{lumiMouseIDMapping_dbconn}: a DBIConnection object representing an open
  connection to the package annotation DB.

  \code{lumiMouseIDMapping_dbfile}: a character string with the path to the
  package annotation DB.

  \code{lumiMouseIDMapping_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI]{dbConnect}}
}

\examples{
  ## Show the database information (meta data)
  lumiMouseIDMapping_dbInfo()  

  ## List the tables included in the database
  conn <- lumiMouseIDMapping_dbconn()
  dbListTables(conn)
}

\keyword{utilities}
\keyword{datasets}

