datacache <- new.env(hash=TRUE, parent=emptyenv())

lumiMouseIDMapping <- function() {
	tableNames <- dbListTables(lumiMouseIDMapping_dbconn())
	tableNames <- tableNames[!(tableNames %in% c('nuID_MappingInfo', 'metadata'))]
	cat('Database includes ID mapping information of following manifest files:\n\t')
	cat(tableNames, sep='\n\t')
	cat("\nIt also includes their nuID mapping information.\n For more details, please type lumiMouseIDMapping_nuID().\n")
}

lumiMouseIDMapping_nuID <- function() {
	tableNames <- dbListTables(lumiMouseIDMapping_dbconn())
	tt <- dbReadTable(lumiMouseIDMapping_dbconn(), 'nuID_MappingInfo')
	fieldNames <- dbListFields(lumiMouseIDMapping_dbconn(), 'nuID_MappingInfo')
	cat(paste('nuID_MappingInfo table includes', nrow(tt), 'unique Mus musculus Illumina probes mapping information.\n'))
	cat(paste('\nThe table includes following fields (see help(lumiMouseIDMapping_nuID) for detailed definition.):\n'))
	cat(fieldNames, sep='\n\t')
}


lumiMouseIDMapping_dbconn <- function() dbconn(datacache)
lumiMouseIDMapping_dbfile <- function() dbfile(datacache)
lumiMouseIDMapping_dbInfo <- function() dbInfo(datacache)

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "lumiMouseIDMapping.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(lumiMouseIDMapping_dbconn())
}

