datacache <- new.env(hash=TRUE, parent=emptyenv())

library(RSQLite)
lumiHumanIDMapping <- function() {
	tableNames <- dbListTables(lumiHumanIDMapping_dbconn())
	tableNames <- tableNames[!(tableNames %in% c('nuID_MappingInfo', 'metadata'))]
	cat('Database includes ID mapping information of following manifest files:\n\t')
	cat(tableNames, sep='\n\t')
	cat("\nIt also includes their nuID mapping information.\n For more details, please type lumiHumanIDMapping_nuID().\n")
}

lumiHumanIDMapping_nuID <- function() {
	tableNames <- dbListTables(lumiHumanIDMapping_dbconn())
	tt <- dbReadTable(lumiHumanIDMapping_dbconn(), 'nuID_MappingInfo')
	fieldNames <- dbListFields(lumiHumanIDMapping_dbconn(), 'nuID_MappingInfo')
	cat(paste('nuID_MappingInfo table includes', nrow(tt), 'unique Homo sapiens Illumina probes mapping information.\n'))
	cat(paste('\nThe table includes following fields (see help(lumiHumanIDMapping_nuID) for detailed definition.):\n'))
	cat(fieldNames, sep='\n\t')
}


lumiHumanIDMapping_dbconn <- function() dbconn(datacache)
lumiHumanIDMapping_dbfile <- function() dbfile(datacache)
lumiHumanIDMapping_dbInfo <- function() dbInfo(datacache)

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "lumiHumanIDMapping.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(lumiHumanIDMapping_dbconn())
}

