\name{lumiHumanAllPFAM}
\alias{lumiHumanAllPFAM}
\title{Map Manufacturer IDs to Pfam IDs}
\description{
  lumiHumanAllPFAM is an R object that provides mappings between a
 manufacturer identifier and the associated Pfam identifiers.
}
\details{
  Each manufacturer identifier maps to a named vector of Pfam identifiers.  The name
  for each Pfam identifier is the IPI accession numbe where this Pfam identifier is found.

  If the Pfam is a named NA, it means that the associated Entrez Gene id
  of this manufacturer identifier is found in an IPI entry of the IPI database,
  but there is no Pfam identifier in the entry.

  If the Pfam is a non-named NA, it means that the associated Entrez Gene id
  of this manufacturer identifier is not found in any IPI entry of the IPI database.

   Mappings were based on data provided by: Uniprot  
  http://www.UniProt.org/  
  With a date stamp from the source of: Mon Sep 16 12:05:19 2013

}
\examples{
        x <- lumiHumanAllPFAM
        # Get the probe identifiers that are mapped to any Pfam ID
        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        # randomly display 10 probes
        sample(xx, 10)
}
\keyword{datasets}

