
\name{illuminaRatv1_dbconn}

\alias{illuminaRatv1_dbconn}
\alias{illuminaRatv1_dbfile}
\alias{illuminaRatv1_dbschema}
\alias{illuminaRatv1_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  illuminaRatv1_dbconn()
  illuminaRatv1_dbfile()
  illuminaRatv1_dbschema(file="", show.indices=FALSE)
  illuminaRatv1_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{illuminaRatv1_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{illuminaRatv1_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{illuminaRatv1_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{illuminaRatv1_dbschema} prints the schema definition of the
  package annotation DB.

  \code{illuminaRatv1_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{illuminaRatv1_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{illuminaRatv1_dbfile}: a character string with the path to the
  package annotation DB.

  \code{illuminaRatv1_dbschema}: none (invisible \code{NULL}).

  \code{illuminaRatv1_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(illuminaRatv1_dbconn(), "SELECT COUNT(*) FROM probes")

  illuminaRatv1_dbschema()

  illuminaRatv1_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

