datacache <- new.env(hash=TRUE, parent=emptyenv())

illuminaMousev1p1 <- function() {
cat("####Mappings based on RefSeqID####\n")
showQCData("illuminaMousev1p1", datacache)
cat("####Custom Mappings based on probe sequence####\n")
illuminaMousev1p1listNewMappings()

}
illuminaMousev1p1_dbconn <- function() dbconn(datacache)
illuminaMousev1p1_dbfile <- function() dbfile(datacache)
illuminaMousev1p1_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
illuminaMousev1p1_dbInfo <- function() dbInfo(datacache)

illuminaMousev1p1ORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "illuminaMousev1p1.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "illuminaMousev1p1", "chip illuminaMousev1p1", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("illuminaMousev1p1.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(illuminaMousev1p1_dbconn())
}

##Custom Bimaps for the package

illuminaMousev1p1ARRAYADDRESS <- createSimpleBimap("ExtraInfo", "IlluminaID","ArrayAddress", datacache, "ARRAYADDRESS","illuminaMousev1p1.db")

illuminaMousev1p1NUID <- createSimpleBimap("ExtraInfo", "IlluminaID","NuID", datacache, "NUID","illuminaMousev1p1.db")

illuminaMousev1p1PROBEQUALITY <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeQuality", datacache, "PROBEQUALITY","illuminaMousev1p1.db")

illuminaMousev1p1CODINGZONE <- createSimpleBimap("ExtraInfo", "IlluminaID","CodingZone", datacache, "CODINGZONE","illuminaMousev1p1.db")

illuminaMousev1p1PROBESEQUENCE <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeSequence", datacache, "PROBESEQUENCE","illuminaMousev1p1.db")

illuminaMousev1p1SECONDMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","SecondMatches", datacache, "SECONDMATCHES","illuminaMousev1p1.db")

illuminaMousev1p1OTHERGENOMICMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","OtherGenomicMatches", datacache, "OTHERGENOMICMATCHES","illuminaMousev1p1.db")

illuminaMousev1p1REPEATMASK <- createSimpleBimap("ExtraInfo", "IlluminaID","RepeatMask", datacache, "REPEATMASK","illuminaMousev1p1.db")

illuminaMousev1p1OVERLAPPINGSNP <- createSimpleBimap("ExtraInfo", "IlluminaID","OverlappingSNP", datacache, "OVERLAPPINGSNP","illuminaMousev1p1.db")

illuminaMousev1p1ENTREZREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EntrezReannotated", datacache, "ENTREZREANNOTATED","illuminaMousev1p1.db")

illuminaMousev1p1GENOMICLOCATION <- createSimpleBimap("ExtraInfo", "IlluminaID","GenomicLocation", datacache, "GENOMICLOCATION","illuminaMousev1p1.db")

illuminaMousev1p1SYMBOLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","SymbolReannotated", datacache, "SYMBOLREANNOTATED","illuminaMousev1p1.db")

illuminaMousev1p1REPORTERGROUPNAME <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupName", datacache, "REPORTERGROUPNAME","illuminaMousev1p1.db")

illuminaMousev1p1REPORTERGROUPID <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupID", datacache, "REPORTERGROUPID","illuminaMousev1p1.db")

illuminaMousev1p1ENSEMBLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EnsemblReannotated", datacache, "ENSEMBLREANNOTATED","illuminaMousev1p1.db")

illuminaMousev1p1listNewMappings = function(){
cat("illuminaMousev1p1ARRAYADDRESS()\n") 
cat("illuminaMousev1p1NUID()\n") 
cat("illuminaMousev1p1PROBEQUALITY()\n") 
cat("illuminaMousev1p1CODINGZONE()\n") 
cat("illuminaMousev1p1PROBESEQUENCE()\n") 
cat("illuminaMousev1p1SECONDMATCHES()\n") 
cat("illuminaMousev1p1OTHERGENOMICMATCHES()\n") 
cat("illuminaMousev1p1REPEATMASK()\n") 
cat("illuminaMousev1p1OVERLAPPINGSNP()\n") 
cat("illuminaMousev1p1ENTREZREANNOTATED()\n") 
cat("illuminaMousev1p1GENOMICLOCATION()\n") 
cat("illuminaMousev1p1SYMBOLREANNOTATED()\n") 
cat("illuminaMousev1p1REPORTERGROUPNAME()\n") 
cat("illuminaMousev1p1REPORTERGROUPID()\n") 
cat("illuminaMousev1p1ENSEMBLREANNOTATED()\n") 
}
illuminaMousev1p1fullReannotation = function(){
dbGetQuery(illuminaMousev1p1_dbconn(), "SELECT * FROM ExtraInfo")
}
