
\name{illuminaHumanv3_dbconn}

\alias{illuminaHumanv3_dbconn}
\alias{illuminaHumanv3_dbfile}
\alias{illuminaHumanv3_dbschema}
\alias{illuminaHumanv3_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  illuminaHumanv3_dbconn()
  illuminaHumanv3_dbfile()
  illuminaHumanv3_dbschema(file="", show.indices=FALSE)
  illuminaHumanv3_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{illuminaHumanv3_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{illuminaHumanv3_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{illuminaHumanv3_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{illuminaHumanv3_dbschema} prints the schema definition of the
  package annotation DB.

  \code{illuminaHumanv3_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{illuminaHumanv3_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{illuminaHumanv3_dbfile}: a character string with the path to the
  package annotation DB.

  \code{illuminaHumanv3_dbschema}: none (invisible \code{NULL}).

  \code{illuminaHumanv3_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(illuminaHumanv3_dbconn(), "SELECT COUNT(*) FROM probes")

  illuminaHumanv3_dbschema()

  illuminaHumanv3_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

