\name{illuminaHumanv3listNewMappings}
\alias{illuminaHumanv3ARRAYADDRESS}
\alias{illuminaHumanv3NUID}
\alias{illuminaHumanv3PROBESEQUENCE}
\alias{illuminaHumanv3PROBEQUALITY}
\alias{illuminaHumanv3CODINGZONE}
\alias{illuminaHumanv3GENOMICLOCATION}
\alias{illuminaHumanv3GENOMICMATCHSIMILARITY}
\alias{illuminaHumanv3SECONDMATCHES}
\alias{illuminaHumanv3SECONDMATCHSIMILARITY}
\alias{illuminaHumanv3TRANSCRIPTOMICMATCHSIMILARITY}
\alias{illuminaHumanv3OTHERGENOMICMATCHES}
\alias{illuminaHumanv3REPEATMASK}
\alias{illuminaHumanv3OVERLAPPINGSNP}
\alias{illuminaHumanv3ENTREZREANNOTATED}
\alias{illuminaHumanv3ENSEMBLREANNOTATED}
\alias{illuminaHumanv3SYMBOLREANNOTATED}
\alias{illuminaHumanv3listNewMappings}
\alias{illuminaHumanv3fullReannotation}
\alias{illuminaHumanv3REPORTERGROUPNAME}
\alias{illuminaHumanv3REPORTERGROUPID}

\title{Custom mappings added to the package}
\description{
We have used an extensive re-annotation of the illuminaHumanv3 probe sequences to provide additional information that is not captured in the standard Bioconductor packages. Whereas Bioconductor annotations are based on the RefSeq ID that each probe maps to, our additional mappings provide data specific to each probe on the platform. See below for details. We recommend using the probe quality as a form of filtering, and retaining only perfect or good probes for an analysis. 

}

\section{Details of custom mappings}{

\describe{

\item{illuminaHumanv3listNewMappings}{List all the custom re-annotation mappings provided by the package}

\item{illuminaHumanv3fullReannotation}{Return all the re-annotation information as a matrix}

\item{illuminaHumanv3ARRAYADDRESS}{Array Address code used to identify the probe at the bead-level}

\item{illuminaHumanv3NUID}{Lumi's nuID (universal naming scheme for oligonucleotides) Reference: Du et al. (2007), Biol Direct 2:16}

\item{illuminaHumanv3PROBESEQUENCE}{The 50 base sequence for the probe}

\item{illuminaHumanv3PROBEQUALITY}{Quality grade assigned to the probe: \dQuote{Perfect} if it perfectly and uniquely matches the target transcript; \dQuote{Good} if the probe, although imperfectly matching the target transcript, is still likely to provide considerably sensitive signal (up to two mismatches are allowed, based on empirical evidence that the signal intensity for 50-mer probes with less than 95\% identity to the respective targets is less than 50\% of the signal associated with perfect matches *); \dQuote{Bad} if the probe matches repeat sequences, intergenic or intronic regions, or is unlikely to provide specific signal for any transcript; \dQuote{No match} if it does not match any genomic region or transcript.}

\item{illuminaHumanv3CODINGZONE}{Coding status of target sequence: intergenic / intronic / Transcriptomic (\dQuote{Transcriptomic} when the target transcript is non-coding or there is no information on the coding sequence)}

\item{illuminaHumanv3GENOMICLOCATION}{Probe's genomic coordinates (hg19 for human, mm9 for mouse or rn4 for rat)}

\item{illuminaHumanv3GENOMICMATCHSIMILARITY}{Percentage of similarity between the probe and its best genomic match in the alignable region, taking the probe as reference}

\item{illuminaHumanv3SECONDMATCHES}{Genomic coordinates of second best matches between the probe and the genome}

\item{illuminaHumanv3SECONDMATCHSIMILARITY}{Percentage of similarity between the probe and its second best genomic match in the alignable region, taking the probe as reference}

\item{illuminaHumanv3TRANSCRIPTOMICMATCHSIMILARITY}{Percentage of similarity between the probe and its target transcript in the alignable region, taking the probe as reference}

\item{illuminaHumanv3OTHERGENOMICMATCHES}{Genomic coordinates of sequences as alignable with the probe (in terms of number of matching nucleotides) as its main target}

\item{illuminaHumanv3REPEATMASK}{Overlapping RepeatMasked sequences, with number of bases overlapped by the repeat}

\item{illuminaHumanv3OVERLAPPINGSNP}{Overlapping annotated SNPs}

\item{illuminaHumanv3ENTREZREANNOTATED}{Entrez IDs}

\item{illuminaHumanv3ENSEMBLREANNOTATED}{Ensembl IDs}

\item{illuminaHumanv3SYMBOLREANNOTATED}{Gene symbol derived by re-annotation}

\item{illuminaHumanv3REPORTERGROUPID}{For probes marked as controls in Illuminas annotation file, these gives the type of control}

\item{illuminaHumanv3REPORTERGROUPNAME}{Usually a more informative name for the control type}



}

}

\references{
  \url{http://remoat.sysbiol.cam.ac.uk}


 Barbosa-Morais et al. (2010) A re-annotation pipeline for Illumina BeadArrays: improving the interpretation of gene expression data. Nucleic Acids Research

}
\examples{

	##See what new mappings are available

	illuminaHumanv3listNewMappings()
	

        x <- illuminaHumanv3PROBEQUALITY

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the PROBEQUALITY for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }


	##Overall table of qualities
	table(unlist(xx))

	

        x <- illuminaHumanv3ARRAYADDRESS

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the ARRAYADDRESS for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

	##Can do the mapping from array address to illumina ID using a revmap
	
	y<- revmap(illuminaHumanv3ARRAYADDRESS)
	
        mapped_probes <- mappedkeys(y)
        # Convert to a list
        yy <- as.list(y[mapped_probes])
        if(length(yy) > 0) {
          # Get the ARRAYADDRESS for the first five probes
          yy[1:5]
          # Get the first one
          yy[[1]]
        }
	


        x <- illuminaHumanv3CODINGZONE

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the CODINGZONE for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        x <- illuminaHumanv3PROBESEQUENCE

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the PROBESEQUENCE for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }


}
\keyword{datasets}
