datacache <- new.env(hash=TRUE, parent=emptyenv())

illuminaHumanv3 <- function() {
cat("####Mappings based on RefSeqID####\n")
showQCData("illuminaHumanv3", datacache)
cat("####Custom Mappings based on probe sequence####\n")
illuminaHumanv3listNewMappings()

}

illuminaHumanv3_dbconn <- function() dbconn(datacache)
illuminaHumanv3_dbfile <- function() dbfile(datacache)
illuminaHumanv3_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
illuminaHumanv3_dbInfo <- function() dbInfo(datacache)

illuminaHumanv3ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "illuminaHumanv3.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "illuminaHumanv3", "chip illuminaHumanv3", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("illuminaHumanv3.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(illuminaHumanv3_dbconn())
}

##Custom Bimaps for the package

illuminaHumanv3ARRAYADDRESS <- createSimpleBimap("ExtraInfo", "IlluminaID","ArrayAddress", datacache, "ARRAYADDRESS","illuminaHumanv3.db")

illuminaHumanv3NUID <- createSimpleBimap("ExtraInfo", "IlluminaID","NuID", datacache, "NUID","illuminaHumanv3.db")

illuminaHumanv3PROBEQUALITY <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeQuality", datacache, "PROBEQUALITY","illuminaHumanv3.db")

illuminaHumanv3CODINGZONE <- createSimpleBimap("ExtraInfo", "IlluminaID","CodingZone", datacache, "CODINGZONE","illuminaHumanv3.db")

illuminaHumanv3PROBESEQUENCE <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeSequence", datacache, "PROBESEQUENCE","illuminaHumanv3.db")

illuminaHumanv3SECONDMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","SecondMatches", datacache, "SECONDMATCHES","illuminaHumanv3.db")

illuminaHumanv3OTHERGENOMICMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","OtherGenomicMatches", datacache, "OTHERGENOMICMATCHES","illuminaHumanv3.db")

illuminaHumanv3REPEATMASK <- createSimpleBimap("ExtraInfo", "IlluminaID","RepeatMask", datacache, "REPEATMASK","illuminaHumanv3.db")

illuminaHumanv3OVERLAPPINGSNP <- createSimpleBimap("ExtraInfo", "IlluminaID","OverlappingSNP", datacache, "OVERLAPPINGSNP","illuminaHumanv3.db")

illuminaHumanv3ENTREZREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EntrezReannotated", datacache, "ENTREZREANNOTATED","illuminaHumanv3.db")

illuminaHumanv3GENOMICLOCATION <- createSimpleBimap("ExtraInfo", "IlluminaID","GenomicLocation", datacache, "GENOMICLOCATION","illuminaHumanv3.db")

illuminaHumanv3SYMBOLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","SymbolReannotated", datacache, "SYMBOLREANNOTATED","illuminaHumanv3.db")

illuminaHumanv3REPORTERGROUPNAME <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupName", datacache, "REPORTERGROUPNAME","illuminaHumanv3.db")

illuminaHumanv3REPORTERGROUPID <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupID", datacache, "REPORTERGROUPID","illuminaHumanv3.db")

illuminaHumanv3ENSEMBLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EnsemblReannotated", datacache, "ENSEMBLREANNOTATED","illuminaHumanv3.db")

illuminaHumanv3listNewMappings = function(){
cat("illuminaHumanv3ARRAYADDRESS()\n") 
cat("illuminaHumanv3NUID()\n") 
cat("illuminaHumanv3PROBEQUALITY()\n") 
cat("illuminaHumanv3CODINGZONE()\n") 
cat("illuminaHumanv3PROBESEQUENCE()\n") 
cat("illuminaHumanv3SECONDMATCHES()\n") 
cat("illuminaHumanv3OTHERGENOMICMATCHES()\n") 
cat("illuminaHumanv3REPEATMASK()\n") 
cat("illuminaHumanv3OVERLAPPINGSNP()\n") 
cat("illuminaHumanv3ENTREZREANNOTATED()\n") 
cat("illuminaHumanv3GENOMICLOCATION()\n") 
cat("illuminaHumanv3SYMBOLREANNOTATED()\n") 
cat("illuminaHumanv3REPORTERGROUPNAME()\n") 
cat("illuminaHumanv3REPORTERGROUPID()\n") 
cat("illuminaHumanv3ENSEMBLREANNOTATED()\n") 
}
illuminaHumanv3fullReannotation = function(){
dbGetQuery(illuminaHumanv3_dbconn(), "SELECT * FROM ExtraInfo")
}
