
\name{illuminaHumanv2BeadID_dbconn}

\alias{illuminaHumanv2BeadID_dbconn}
\alias{illuminaHumanv2BeadID_dbfile}
\alias{illuminaHumanv2BeadID_dbschema}
\alias{illuminaHumanv2BeadID_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  illuminaHumanv2BeadID_dbconn()
  illuminaHumanv2BeadID_dbfile()
  illuminaHumanv2BeadID_dbschema(file="", show.indices=FALSE)
  illuminaHumanv2BeadID_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{illuminaHumanv2BeadID_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{illuminaHumanv2BeadID_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{illuminaHumanv2BeadID_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{illuminaHumanv2BeadID_dbschema} prints the schema definition of the
  package annotation DB.

  \code{illuminaHumanv2BeadID_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{illuminaHumanv2BeadID_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{illuminaHumanv2BeadID_dbfile}: a character string with the path to the
  package annotation DB.

  \code{illuminaHumanv2BeadID_dbschema}: none (invisible \code{NULL}).

  \code{illuminaHumanv2BeadID_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(illuminaHumanv2BeadID_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by illuminaHumanv2BeadID_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=illuminaHumanv2BeadID_dbfile(), cache_size=64000,
  synchronous=0)

  illuminaHumanv2BeadID_dbschema()

  illuminaHumanv2BeadID_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

