
\name{illuminaHumanv2_dbconn}

\alias{illuminaHumanv2_dbconn}
\alias{illuminaHumanv2_dbfile}
\alias{illuminaHumanv2_dbschema}
\alias{illuminaHumanv2_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  illuminaHumanv2_dbconn()
  illuminaHumanv2_dbfile()
  illuminaHumanv2_dbschema(file="", show.indices=FALSE)
  illuminaHumanv2_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{illuminaHumanv2_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{illuminaHumanv2_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{illuminaHumanv2_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{illuminaHumanv2_dbschema} prints the schema definition of the
  package annotation DB.

  \code{illuminaHumanv2_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{illuminaHumanv2_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{illuminaHumanv2_dbfile}: a character string with the path to the
  package annotation DB.

  \code{illuminaHumanv2_dbschema}: none (invisible \code{NULL}).

  \code{illuminaHumanv2_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(illuminaHumanv2_dbconn(), "SELECT COUNT(*) FROM probes")

  illuminaHumanv2_dbschema()

  illuminaHumanv2_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

