datacache <- new.env(hash=TRUE, parent=emptyenv())
illuminaHumanv1 <- function(){
cat("####Mappings based on RefSeqID####\n")
showQCData("illuminaHumanv1", datacache)
cat("####Custom Mappings based on probe sequence####\n")
illuminaHumanv1listNewMappings()
}

illuminaHumanv1_dbconn <- function() dbconn(datacache)
illuminaHumanv1_dbfile <- function() dbfile(datacache)
illuminaHumanv1_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
illuminaHumanv1_dbInfo <- function() dbInfo(datacache)

illuminaHumanv1ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "illuminaHumanv1.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "illuminaHumanv1", "chip illuminaHumanv1", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("illuminaHumanv1.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(illuminaHumanv1_dbconn())
}

##Custom Bimaps for the package

illuminaHumanv1ARRAYADDRESS <- createSimpleBimap("ExtraInfo", "IlluminaID","ArrayAddress", datacache, "ARRAYADDRESS","illuminaHumanv1.db")

illuminaHumanv1PROBESEQUENCE <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeSequence", datacache, "PROBESEQUENCE","illuminaHumanv1.db")

illuminaHumanv1REPORTERGROUPNAME <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupName", datacache, "REPORTERGROUPNAME","illuminaHumanv1.db")

illuminaHumanv1REPORTERGROUPID <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupID", datacache, "REPORTERGROUPID","illuminaHumanv1.db")

illuminaHumanv1NUID <- createSimpleBimap("ExtraInfo", "IlluminaID","NuID", datacache, "NUID","illuminaHumanv1.db")

illuminaHumanv1PROBEQUALITY <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeQuality", datacache, "PROBEQUALITY","illuminaHumanv1.db")

illuminaHumanv1CODINGZONE <- createSimpleBimap("ExtraInfo", "IlluminaID","CodingZone", datacache, "CODINGZONE","illuminaHumanv1.db")

illuminaHumanv1SECONDMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","SecondMatches", datacache, "SECONDMATCHES","illuminaHumanv1.db")

illuminaHumanv1OTHERGENOMICMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","OtherGenomicMatches", datacache, "OTHERGENOMICMATCHES","illuminaHumanv1.db")

illuminaHumanv1REPEATMASK <- createSimpleBimap("ExtraInfo", "IlluminaID","RepeatMask", datacache, "REPEATMASK","illuminaHumanv1.db")

illuminaHumanv1OVERLAPPINGSNP <- createSimpleBimap("ExtraInfo", "IlluminaID","OverlappingSNP", datacache, "OVERLAPPINGSNP","illuminaHumanv1.db")

illuminaHumanv1ENTREZREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EntrezReannotated", datacache, "ENTREZREANNOTATED","illuminaHumanv1.db")

illuminaHumanv1GENOMICLOCATION <- createSimpleBimap("ExtraInfo", "IlluminaID","GenomicLocation", datacache, "GENOMICLOCATION","illuminaHumanv1.db")

illuminaHumanv1SYMBOLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","SymbolReannotated", datacache, "SYMBOLREANNOTATED","illuminaHumanv1.db")

illuminaHumanv1ENSEMBLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EnsemblReannotated", datacache, "ENSEMBLREANNOTATED","illuminaHumanv1.db")

illuminaHumanv1listNewMappings = function(){
cat("illuminaHumanv1ARRAYADDRESS()\n") 
cat("illuminaHumanv1PROBESEQUENCE()\n") 
cat("illuminaHumanv1REPORTERGROUPNAME()\n") 
cat("illuminaHumanv1REPORTERGROUPID()\n") 
cat("illuminaHumanv1NUID()\n") 
cat("illuminaHumanv1PROBEQUALITY()\n") 
cat("illuminaHumanv1CODINGZONE()\n") 
cat("illuminaHumanv1SECONDMATCHES()\n") 
cat("illuminaHumanv1OTHERGENOMICMATCHES()\n") 
cat("illuminaHumanv1REPEATMASK()\n") 
cat("illuminaHumanv1OVERLAPPINGSNP()\n") 
cat("illuminaHumanv1ENTREZREANNOTATED()\n") 
cat("illuminaHumanv1GENOMICLOCATION()\n") 
cat("illuminaHumanv1SYMBOLREANNOTATED()\n") 
cat("illuminaHumanv1ENSEMBLREANNOTATED()\n") 
}
illuminaHumanv1fullReannotation = function(){
dbGetQuery(illuminaHumanv1_dbconn(), "SELECT * FROM ExtraInfo")
}
