\name{illuminaHumanWGDASLv4listNewMappings}
\alias{illuminaHumanWGDASLv4ARRAYADDRESS}
\alias{illuminaHumanWGDASLv4NUID}
\alias{illuminaHumanWGDASLv4PROBESEQUENCE}
\alias{illuminaHumanWGDASLv4PROBEQUALITY}
\alias{illuminaHumanWGDASLv4CODINGZONE}
\alias{illuminaHumanWGDASLv4GENOMICLOCATION}
\alias{illuminaHumanWGDASLv4GENOMICMATCHSIMILARITY}
\alias{illuminaHumanWGDASLv4SECONDMATCHES}
\alias{illuminaHumanWGDASLv4SECONDMATCHSIMILARITY}
\alias{illuminaHumanWGDASLv4TRANSCRIPTOMICMATCHSIMILARITY}
\alias{illuminaHumanWGDASLv4OTHERGENOMICMATCHES}
\alias{illuminaHumanWGDASLv4REPEATMASK}
\alias{illuminaHumanWGDASLv4OVERLAPPINGSNP}
\alias{illuminaHumanWGDASLv4ENTREZREANNOTATED}
\alias{illuminaHumanWGDASLv4ENSEMBLREANNOTATED}
\alias{illuminaHumanWGDASLv4SYMBOLREANNOTATED}
\alias{illuminaHumanWGDASLv4listNewMappings}
\alias{illuminaHumanWGDASLv4fullReannotation}
\alias{illuminaHumanWGDASLv4REPORTERGROUPNAME}
\alias{illuminaHumanWGDASLv4REPORTERGROUPID}

\title{Custom mappings added to the package}
\description{
We have used an extensive re-annotation of the illuminaHumanWGDASLv4 probe sequences to provide additional information that is not captured in the standard Bioconductor packages. Whereas Bioconductor annotations are based on the RefSeq ID that each probe maps to, our additional mappings provide data specific to each probe on the platform. See below for details. We recommend using the probe quality as a form of filtering, and retaining only perfect or good probes for an analysis. 

}

\section{Details of custom mappings}{

\describe{

\item{illuminaHumanWGDASLv4listNewMappings}{List all the custom re-annotation mappings provided by the package}

\item{illuminaHumanWGDASLv4fullReannotation}{Return all the re-annotation information as a matrix}

\item{illuminaHumanWGDASLv4ARRAYADDRESS}{Array Address code used to identify the probe at the bead-level}

\item{illuminaHumanWGDASLv4NUID}{Lumi's nuID (universal naming scheme for oligonucleotides) Reference: Du et al. (2007), Biol Direct 2:16}

\item{illuminaHumanWGDASLv4PROBESEQUENCE}{The 50 base sequence for the probe}

\item{illuminaHumanWGDASLv4PROBEQUALITY}{Quality grade assigned to the probe: \dQuote{Perfect} if it perfectly and uniquely matches the target transcript; \dQuote{Good} if the probe, although imperfectly matching the target transcript, is still likely to provide considerably sensitive signal (up to two mismatches are allowed, based on empirical evidence that the signal intensity for 50-mer probes with less than 95\% identity to the respective targets is less than 50\% of the signal associated with perfect matches *); \dQuote{Bad} if the probe matches repeat sequences, intergenic or intronic regions, or is unlikely to provide specific signal for any transcript; \dQuote{No match} if it does not match any genomic region or transcript.}

\item{illuminaHumanWGDASLv4CODINGZONE}{Coding status of target sequence: intergenic / intronic / Transcriptomic (\dQuote{Transcriptomic} when the target transcript is non-coding or there is no information on the coding sequence)}

\item{illuminaHumanWGDASLv4GENOMICLOCATION}{Probe's genomic coordinates (hg19 for human, mm9 for mouse or rn4 for rat)}

\item{illuminaHumanWGDASLv4GENOMICMATCHSIMILARITY}{Percentage of similarity between the probe and its best genomic match in the alignable region, taking the probe as reference}

\item{illuminaHumanWGDASLv4SECONDMATCHES}{Genomic coordinates of second best matches between the probe and the genome}

\item{illuminaHumanWGDASLv4SECONDMATCHSIMILARITY}{Percentage of similarity between the probe and its second best genomic match in the alignable region, taking the probe as reference}

\item{illuminaHumanWGDASLv4TRANSCRIPTOMICMATCHSIMILARITY}{Percentage of similarity between the probe and its target transcript in the alignable region, taking the probe as reference}

\item{illuminaHumanWGDASLv4OTHERGENOMICMATCHES}{Genomic coordinates of sequences as alignable with the probe (in terms of number of matching nucleotides) as its main target}

\item{illuminaHumanWGDASLv4REPEATMASK}{Overlapping RepeatMasked sequences, with number of bases overlapped by the repeat}

\item{illuminaHumanWGDASLv4OVERLAPPINGSNP}{Overlapping annotated SNPs}

\item{illuminaHumanWGDASLv4ENTREZREANNOTATED}{Entrez IDs}

\item{illuminaHumanWGDASLv4ENSEMBLREANNOTATED}{Ensembl IDs}

\item{illuminaHumanWGDASLv4SYMBOLREANNOTATED}{Gene symbol derived by re-annotation}

\item{illuminaHumanWGDASLv4REPORTERGROUPID}{For probes marked as controls in Illuminas annotation file, these gives the type of control}

\item{illuminaHumanWGDASLv4REPORTERGROUPNAME}{Usually a more informative name for the control type}



}

}

\references{
  \url{http://remoat.sysbiol.cam.ac.uk}


 Barbosa-Morais et al. (2010) A re-annotation pipeline for Illumina BeadArrays: improving the interpretation of gene expression data. Nucleic Acids Research

}
\examples{

	##See what new mappings are available

	illuminaHumanWGDASLv4listNewMappings()
	

        x <- illuminaHumanWGDASLv4PROBEQUALITY

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the PROBEQUALITY for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }


	##Overall table of qualities
	table(unlist(xx))

	

        x <- illuminaHumanWGDASLv4ARRAYADDRESS

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the ARRAYADDRESS for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

	##Can do the mapping from array address to illumina ID using a revmap
	
	y<- revmap(illuminaHumanWGDASLv4ARRAYADDRESS)
	
        mapped_probes <- mappedkeys(y)
        # Convert to a list
        yy <- as.list(y[mapped_probes])
        if(length(yy) > 0) {
          # Get the ARRAYADDRESS for the first five probes
          yy[1:5]
          # Get the first one
          yy[[1]]
        }
	


        x <- illuminaHumanWGDASLv4CODINGZONE

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the CODINGZONE for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        x <- illuminaHumanWGDASLv4PROBESEQUENCE

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the PROBESEQUENCE for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }


}
\keyword{datasets}
