datacache <- new.env(hash=TRUE, parent=emptyenv())

huex10stprobeset <- function() showQCData("huex10stprobeset", datacache)
huex10stprobeset_dbconn <- function() dbconn(datacache)
huex10stprobeset_dbfile <- function() dbfile(datacache)
huex10stprobeset_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
huex10stprobeset_dbInfo <- function() dbInfo(datacache)

huex10stprobesetORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "huex10stprobeset.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "huex10stprobeset", "chip huex10stprobeset", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("huex10stprobeset.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(huex10stprobeset_dbconn())
}

