datacache <- new.env(hash=TRUE, parent=emptyenv())

hthgu133pluspm <- function() showQCData("hthgu133pluspm", datacache)
hthgu133pluspm_dbconn <- function() dbconn(datacache)
hthgu133pluspm_dbfile <- function() dbfile(datacache)
hthgu133pluspm_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hthgu133pluspm_dbInfo <- function() dbInfo(datacache)

hthgu133pluspmORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hthgu133pluspm.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hthgu133pluspm", "chip hthgu133pluspm", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hthgu133pluspm.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hthgu133pluspm_dbconn())
}

