
\name{hs25kresogen_dbconn}

\alias{hs25kresogen_dbconn}
\alias{hs25kresogen_dbfile}
\alias{hs25kresogen_dbschema}
\alias{hs25kresogen_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  hs25kresogen_dbconn()
  hs25kresogen_dbfile()
  hs25kresogen_dbschema(file="", show.indices=FALSE)
  hs25kresogen_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{hs25kresogen_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{hs25kresogen_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{hs25kresogen_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{hs25kresogen_dbschema} prints the schema definition of the
  package annotation DB.

  \code{hs25kresogen_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{hs25kresogen_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{hs25kresogen_dbfile}: a character string with the path to the
  package annotation DB.

  \code{hs25kresogen_dbschema}: none (invisible \code{NULL}).

  \code{hs25kresogen_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(hs25kresogen_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by hs25kresogen_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=hs25kresogen_dbfile(), cache_size=64000,
  synchronous=0)

  hs25kresogen_dbschema()

  hs25kresogen_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

