\name{hgu95av2UNIGENE}
\alias{hgu95av2UNIGENE}
\title{Map between Manufacturer Identifiers and UniGene cluster identifiers}
\description{
   hgu95av2UNIGENE is an R environment that provides mappings between
   manufacturer identifiers and UniGene identifiers.
}
\details{
  Each manufacturer identifier is mapped to a UniGene identifier. An \code{NA} is
  reported if the manufacturer identifier cannot be mapped to UniGene at this time. 

  A UniGene identifier represents a cluster of sequences of a gene. Using
  UniGene identifiers one can query the UniGene database for information about
  the sequences or the Entrez Gene database for information about the
  genes.  
  
  Mappings were based on data provided by:

  Entrez Gene:\\url{ftp://ftp.ncbi.nlm.nih.gov/gene/DATA/}. Built: Source data downloaded from Entrez Gene on Thu Mar 15 20:55:24 2007

  Package built Thu Mar 15 21:19:18 2007
}
\references{
  \url{http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=gene}
}
\examples{
    # Convert the environment to a list
    xx <- as.list(hgu95av2UNIGENE)
    # Remove probe identifiers that do no map to any UniGene id
    xx <- xx[!is.null(xx)]
    if(length(xx) > 0){
        # The UniGene identifiers for the first two elements of XX
        xx[1:2]
        # Get the first one
        xx[[1]]
    }
}

\keyword{datasets}

