\name{hgu95av2SYMBOL}
\alias{hgu95av2SYMBOL}
\title{Map between Manufacturer Identifiers and Gene Symbols}
\description{
  hgu95av2SYMBOL is an R environment that provides mappings between
  manufacturer identifiers and gene abbreviations. 
}
\details{
  Each manufacturer identifier is mapped to an abbreviation for the
  corresponding gene. An \code{NA} is reported if there is no known
  abbreviation for a given gene.
  
  Symbols typically consist of 3 letters that define either a single
  gene (ABC) or multiple genes (ABC1, ABC2, ABC3). Gene symbols can be
  used as key words to query public databases such as Entrez Gene.
  
  Mappings were based on data provided by:
  
  Entrez Gene:\\url{ftp://ftp.ncbi.nlm.nih.gov/gene/DATA/}. Built: Source data downloaded from Entrez Gene on Thu Mar 15 20:55:24 2007
  
  Package built Thu Mar 15 21:19:18 2007
}
\references{
  \url{http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=gene}
}
\examples{
    # Convert the environment to a list
    xx <- as.list(hgu95av2SYMBOL)
    if(length(xx) > 0){
        # The symbols for the first two elements of XX
        xx[1:2]
        # Get the first one
        xx[[1]]
    }
}

\keyword{datasets}

