\name{hgu95av2PMID}
\alias{hgu95av2PMID}
\title{Map between Manufacturer Identifiers and PubMed Identifiers}
\description{
   hgu95av2PMID is an R environment that provides mappings between
   manufacturer identifiers and PubMed identifiers.
}
\details{
  Each manufacturer identifier is mapped to a named vector of PubMed identifiers. The
  name associated with each vector corresponds to the manufacturer
  identifier. The length of the vector may be one or greater, depending on how
  many PubMed identifiers a given manufacturer identifier is mapped to. An \code{NA} is
  reported for any manufacturer identifier that cannot be mapped to a PubMed identifier.

  Titles, abstracts, and possibly full texts of articles can be obtained
  from PubMed by providing a valid PubMed identifier. The pubmed function of
  annotate can also be used for the same purpose.

  Mappings were based on data provided by:

  Entrez Gene:\\url{ftp://ftp.ncbi.nlm.nih.gov/gene/DATA/}. Built: Source data downloaded from Entrez Gene on Thu Mar 15 20:55:24 2007

  Package built Thu Mar 15 21:19:18 2007
}
\references{
  \url{http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=PubMed}
}
\examples{
    # Convert the environment to a list
    xx <- as.list(hgu95av2PMID)
    if(length(xx) > 0){
        # The probe identifiers for the first two elements of XX
        xx[1:2]
        # Get the first one
        xx[[1]]
        if(interactive() && !is.null(xx[[1]]) && !is.na(xx[[1]])
           && require(annotate)){
            # Gets article information as XML files
            xmls <- pubmed(xx[[1]], disp = "data")
            # Views article information using a browser
            pubmed(xx[[1]], disp = "browser")
        }
    }
}
\keyword{datasets}

