\name{hgu95av2ENZYME}
\alias{hgu95av2ENZYME}
\title{Map Between Manufacturer IDs and Enzyme Commission (EC) Numbers}
\description{ 
  hgu95av2ENZYME is an R environment that provides mappings between
  manufacturer identifiers and EC numbers. 
}
\details{
  Each manufacturer identifier maps to a named vector containing the EC number that
  corresponds to the enzyme produced by that gene. The name corresponds
  to the manufacturer identifier. If this information is unknown, the vector
  will contain an \code{NA}.
  
  Enzyme Commission numbers are assigned by the Nomenclature Committee
  of the International Union of Biochemistry and Molecular Biology
  \url{http://www.chem.qmw.ac.uk/iubmb/enzyme/} to allow enzymes to be
  identified. 
  
  An Enzyme Commission number is of the format EC x.y.z.w, where x, y, z,
  and w are numeric numbers. In hgu95av2ENZYME2PROBE, EC is dropped from the
  Enzyme Commission numbers.

  Enzyme Commission numbers have corresponding names that describe the
  functions of enzymes in such a way that EC x is a more general
  description than EC x.y that in turn is a more general description than
  EC x.y.z. The top level EC numbers and names are listed below:

  EC 1 oxidoreductases
  
  EC 2 transferases

  EC 3 hydrolases

  EC 4 lyases
  
  EC 5 isomerases
  
  EC 6 ligases
  
  The EC name for a given EC number can be viewed at
  \url{http://www.chem.qmul.ac.uk/iupac/jcbn/index.html#6} 
  
  Mappings between probe identifiers and enzyme identifiers were obtained using files
  provided by:

  KEGG:\\url{ftp://ftp.genome.ad.jp/pub/kegg/tarfiles/pathway.tar.gz}. Built: Release 41.1, February 1, 2007

  Entrez Gene:\\url{ftp://ftp.ncbi.nlm.nih.gov/gene/DATA/}. Built: Source data downloaded from Entrez Gene on Thu Mar 15 20:55:24 2007
  
  Package built Thu Mar 15 21:19:18 2007
}
\references{
\url{ftp://ftp.genome.ad.jp/pub/kegg/pathways}
}
\examples{
        # Convert to a list
        xx <- as.list(hgu95av2ENZYME)
        # Remove probe identifiers that do not map to any enzyme EC number
        xx <- xx[!is.na(xx)]
        if(length(xx) > 0){
        # Gets the enzyme commission numbers for the first five
        #probes
        xx[1:5]
        # Get the first one
        xx[[1]]
}
}
\keyword{datasets}

